//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#property indicator_type1           DRAW_COLOR_LINE
#property indicator_color1          clrMaroon, clrTomato, clrBlue
//+----------------+
#property indicator_type2           DRAW_COLOR_LINE
#property indicator_color2          clrGreen, clrPaleGreen
//+----------------+
#property indicator_buffers         4
#property indicator_plots           2
//+----------------+
double   gl_buff_max[],
         gl_buff_min[],
         gl_color_max[],
         gl_color_min[];
//+------------------------------------------------------------------+
int OnInit()
{
    SetIndexBuffer(0, gl_buff_max, INDICATOR_DATA);
    SetIndexBuffer(1, gl_color_max, INDICATOR_COLOR_INDEX);
    SetIndexBuffer(2, gl_buff_min, INDICATOR_DATA);
    SetIndexBuffer(3, gl_color_min, INDICATOR_COLOR_INDEX);

    return INIT_SUCCEEDED;
};
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total, const int prev_calculated, const datetime &Time[], const double &Open[], const double &High[], const double &Low[], const double &Close[], const long &TickVolume[], const long &Volume[], const int &Spread[])
{
    double  mhs = 0,
            mhi = 0,
            ml = 0;
    const double desv = 0.01;

    for (int c = (prev_calculated > 0 ? prev_calculated - 1 : 0); c < rates_total; c++)
    {
        gl_color_max[c] = (mhi > High[c] ? 0 : (mhs < High[c] ? 1 : 2));
        mhs = mhi = gl_buff_max[c] = High[c];
        mhs += (mhs * desv);
        mhi -= (mhi * desv);
        gl_color_min[c] = (ml < Low[c] ? 0 : 1);
        ml = gl_buff_min[c] = Low[c];
    }

    return rates_total;
};
//+------------------------------------------------------------------+